﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_11_2
{
    public class Chapitre11_2 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Map map;
        Tile herosA;
        Tile herosBOnA;
        Tile herosB;
        Tile herosAOnB;

        Rectangle cameraA;  
        Rectangle cameraB;

        Viewport viewportA;
        Viewport viewportB;

        public Chapitre11_2()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            graphics.PreferredBackBufferWidth = 160;
            graphics.PreferredBackBufferHeight = 320;
        }

        protected override void Initialize()
        {
            map = new Map(new byte[,] { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
                                      , {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0, 0, 0, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 1, 0, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 1, 0, 1, 0}
                                      , {0, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 1, 0}
                                      , {0, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 0, 0, 3, 3, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 3, 3, 3, 3, 3, 0, 0, 0, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 2, 2, 2, 0, 1, 0}
                                      , {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 2, 2, 0, 1, 0}
                                      , {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}
                                      , {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}});

            cameraA = new Rectangle(0, 0, 5, 5);
            cameraB = new Rectangle(1, 1, 5, 5);

            herosA = new Tile(cameraA.X + 2, cameraA.Y + 2, 4);
            herosA.Position = new Vector2(64, 64);

            herosBOnA = new Tile(0, 0, 5);

            herosB = new Tile(cameraB.X + 2, cameraB.Y + 2, 4);
            herosB.Position = new Vector2(64, 64);

            herosAOnB = new Tile(0, 0, 5);

            viewportA.Width = graphics.PreferredBackBufferWidth;
            viewportA.Height = graphics.PreferredBackBufferHeight / 2;

            viewportB.Y = graphics.PreferredBackBufferHeight / 2;
            viewportB.Width = graphics.PreferredBackBufferWidth;
            viewportB.Height = graphics.PreferredBackBufferHeight / 2;

            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            foreach (Tile tile in map.TileList)
            {
                tile.LoadContent(Content, "tile");
            }
            herosA.LoadContent(Content, "tile");
            herosB.LoadContent(Content, "tile");
            herosAOnB.LoadContent(Content, "tile");
            herosBOnA.LoadContent(Content, "tile");
        }

        protected override void Update(GameTime gameTime)
        {
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Up))
            {
                if (map.TileList[herosA.Y - 1, herosA.X].Type >= 0)
                {
                    cameraA.Y -= 1;
                    herosA.Y -= 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Right))
            {
                if (map.TileList[herosA.Y, herosA.X + 1].Type >= 0)
                {
                    cameraA.X += 1;
                    herosA.X += 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Down))
            {
                if (map.TileList[herosA.Y + 1, herosA.X].Type >= 0)
                {
                    cameraA.Y += 1;
                    herosA.Y += 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Left))
            {
                if (map.TileList[herosA.Y, herosA.X - 1].Type >= 0)
                {
                    cameraA.X -= 1;
                    herosA.X -= 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Z))
            {
                if (map.TileList[herosB.Y - 1, herosB.X].Type >= 0)
                {
                    cameraB.Y -= 1;
                    herosB.Y -= 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.D))
            {
                if (map.TileList[herosB.Y, herosB.X + 1].Type >= 0)
                {
                    cameraB.X += 1;
                    herosB.X += 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.S))
            {
                if (map.TileList[herosB.Y + 1, herosB.X].Type >= 0)
                {
                    cameraB.Y += 1;
                    herosB.Y += 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Q))
            {
                if (map.TileList[herosB.Y, herosB.X - 1].Type >= 0)
                {
                    cameraB.X -= 1;
                    herosB.X -= 1;
                }
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            GraphicsDevice.Viewport = viewportA;
            spriteBatch.Begin();
            map.Draw(spriteBatch, cameraA);
            herosA.Draw(spriteBatch);
            if (cameraA.Contains(herosB.X, herosB.Y))
            {
                herosBOnA.Position = new Vector2((herosB.X - cameraA.X) * 32, (herosB.Y - cameraA.Y) * 32);
                herosBOnA.Draw(spriteBatch);
            }
            spriteBatch.End();

            GraphicsDevice.Viewport = viewportB;
            spriteBatch.Begin();
            map.Draw(spriteBatch, cameraB);
            herosB.Draw(spriteBatch);
            if (cameraB.Contains(herosA.X, herosA.Y))
            {
                herosAOnB.Position = new Vector2((herosA.X - cameraB.X) * 32, (herosA.Y - cameraB.Y) * 32);
                herosAOnB.Draw(spriteBatch);
            }
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
